package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅范围
 * </p>
 *
 * @author ultraman
 * @since 2021-09-09
 */
public enum BorrowScope {

    ELECTRONIC("electronic", "电子部分"),
    PAPER("paper", "纸质部分");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BorrowScope(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BorrowScope fromCode(String code){
        switch(code) {
            case "electronic":
                return ELECTRONIC;
            case "paper":
                return PAPER;
            default:
                return null;
        }
    }
}
