package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案规则Class
 * </p>
 *
 * @author ultraman
 * @since 2021-09-30
 */
public enum ArchiveRuleClass {

    RULE_CHECK_RELATION_TEST("ruleCheckRelationTest", "档案演示规则"),
    RULE_CHECK_RELATION_ARCHIVE_TYPE("ruleCheckRelationArchiveType", "档案类型校验规则"),
    RULE_CHECK_RELATION_OVERALL("ruleCheckRelationOverall", "档案下异常资料校验规则"),
    RULE_CHECK_RELATION_OVERALL_WARN("ruleCheckRelationOverallWarn", "档案下预警资料校验规则");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ArchiveRuleClass(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ArchiveRuleClass fromCode(String code){
        switch(code) {
            case "ruleCheckRelationTest":
                return RULE_CHECK_RELATION_TEST;
            case "ruleCheckRelationArchiveType":
                return RULE_CHECK_RELATION_ARCHIVE_TYPE;
            case "ruleCheckRelationOverall":
                return RULE_CHECK_RELATION_OVERALL;
            case "ruleCheckRelationOverallWarn":
                return RULE_CHECK_RELATION_OVERALL_WARN;
            default:
                return null;
        }
    }
}
