package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅资料状态
 * </p>
 *
 * @author ultraman
 * @since 2021-09-30
 */
public enum BorrowResourceStatus {

    _1("1", "已授权"),
    _2("2", "已借出"),
    _3("3", "已归还");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BorrowResourceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BorrowResourceStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
