package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案提交类型
 * </p>
 *
 * @author ultraman
 * @since 2021-09-30
 */
public enum SubmitType {

    AUTO("auto", "自动"),
    HALF_AUTO("half_auto", "半自动"),
    NO_AUTO("no_auto", "手动");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubmitType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubmitType fromCode(String code){
        switch(code) {
            case "auto":
                return AUTO;
            case "half_auto":
                return HALF_AUTO;
            case "no_auto":
                return NO_AUTO;
            default:
                return null;
        }
    }
}
