package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ArchiveDirectory implements Serializable {

  private static final long serialVersionUID=1L;

  private String directoryName;

  private Long parentId;

  private Long leftValue;

  private Long rightValue;

  private String directoryOrder;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private Long level;

  private String directoryNo;

  private String use;

  private Long count;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("directory_name", directoryName);
      map.put("parent_id", parentId);
      map.put("left_value", leftValue);
      map.put("right_value", rightValue);
      map.put("directory_order", directoryOrder);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("level", level);
      map.put("directory_no", directoryNo);
      map.put("use", use);
      map.put("count", count);
      return map;
  }

  public static ArchiveDirectory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ArchiveDirectory entity = new ArchiveDirectory();
    if(map.containsKey("directory_name")) {
      Object obj = map.get("directory_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirectoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("parent_id")) {
      Object obj = map.get("parent_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setParentId((Long)obj);
        } else if(obj instanceof String) {
          entity.setParentId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setParentId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("left_value")) {
      Object obj = map.get("left_value");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLeftValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setLeftValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLeftValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("right_value")) {
      Object obj = map.get("right_value");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRightValue((Long)obj);
        } else if(obj instanceof String) {
          entity.setRightValue(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setRightValue(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("directory_order")) {
      Object obj = map.get("directory_order");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirectoryOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("level")) {
      Object obj = map.get("level");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLevel((Long)obj);
        } else if(obj instanceof String) {
          entity.setLevel(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setLevel(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("directory_no")) {
      Object obj = map.get("directory_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDirectoryNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("use")) {
      Object obj = map.get("use");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("count")) {
      Object obj = map.get("count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
