package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Attachement implements Serializable {

  private static final long serialVersionUID=1L;

  private String attachmentName;

  private Long companyId;

  private String companyCode;

  private Long orgId;

  private String exceptionInfo;

  private String origSystem;

  private String sensitiveFlag;

  private String loseFlag;

  private String exceptionFlag;

  private String warningFlag;

  private String companyName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String materialStatus;

  private String attachmentNo;

  private String imgUrl;

  private String borrowStatus;

  private String sensitiveSituation;

  private String materialSituation;

  private String attachmentCreateUser;

  private String borrowSituation;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime attachmentCreateTime;

  private String sortingStatus;

  private Long accountDataTypeId;

  private String accountDataTypeName;

  private String accountDataTypeNo;

  private String businessType;

  private String custodyFormType;

  private String exceptionType;

  private String remark;

  private String paperBorrowSituation;

  private String paperBorrowStatus;

  private String orgCode;

  private Long custodyYear;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("attachment_name", attachmentName);
      map.put("company_id", companyId);
      map.put("company_code", companyCode);
      map.put("org_id", orgId);
      map.put("exception_info", exceptionInfo);
      map.put("orig_system", origSystem);
      map.put("sensitive_flag", sensitiveFlag);
      map.put("lose_flag", loseFlag);
      map.put("exception_flag", exceptionFlag);
      map.put("warning_flag", warningFlag);
      map.put("company_name", companyName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("material_status", materialStatus);
      map.put("attachment_no", attachmentNo);
      map.put("img_url", imgUrl);
      map.put("borrow_status", borrowStatus);
      map.put("sensitive_situation", sensitiveSituation);
      map.put("material_situation", materialSituation);
      map.put("attachment_create_user", attachmentCreateUser);
      map.put("borrow_situation", borrowSituation);
      map.put("attachment_create_time", BocpGenUtils.toTimestamp(attachmentCreateTime));
      map.put("sorting_status", sortingStatus);
      map.put("account_data_type_id", accountDataTypeId);
      map.put("account_data_type_name", accountDataTypeName);
      map.put("account_data_type_no", accountDataTypeNo);
      map.put("business_type", businessType);
      map.put("custody_form_type", custodyFormType);
      map.put("exception_type", exceptionType);
      map.put("remark", remark);
      map.put("paper_borrow_situation", paperBorrowSituation);
      map.put("paper_borrow_status", paperBorrowStatus);
      map.put("org_code", orgCode);
      map.put("custody_year", custodyYear);
      return map;
  }

  public static Attachement fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Attachement entity = new Attachement();
    if(map.containsKey("attachment_name")) {
      Object obj = map.get("attachment_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_no")) {
      Object obj = map.get("attachment_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_create_user")) {
      Object obj = map.get("attachment_create_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAttachmentCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attachment_create_time")) {
      Object obj = map.get("attachment_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAttachmentCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAttachmentCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAttachmentCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAttachmentCreateTime(null);
      }
    }
    if(map.containsKey("sorting_status")) {
      Object obj = map.get("sorting_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_situation")) {
      Object obj = map.get("paper_borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paper_borrow_status")) {
      Object obj = map.get("paper_borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custody_year")) {
      Object obj = map.get("custody_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setCustodyYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCustodyYear(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
