package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BorrowApplyInfo implements Serializable {

  private static final long serialVersionUID=1L;

  private Long companyId;

  private Long orgId;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String status;

  private String flowNo;

  private String borrowUserCode;

  private String borrowUsername;

  private String companyName;

  private String departmentName;

  private String borrowPhone;

  private String borrowMail;

  private String position;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyStartTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyEndTime;

  private String reason;

  private String content;

  private String fileType;

  private String type;

  private String address;

  private String remark;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime authTime;

  private String authTypes;

  private String authUsername;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime borrowTime;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime returnTime;

  private String borrowLendUsername;

  private String loseFlag;

  private String overdueFlag;

  private String borrowSituation;

  private String borrowDuration;

  private Long borrowUserId;

  private String approvalBusinessKey;

  private String approvalPendingUserId;

  private String approvalProcessInfo;

  private String approvalRejectFlag;

  private String approvalRejectRemark;

  private String approvalStatus;

  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime approvalRejectTime;

  private String approvalRejecter;

  private String channel;

  private String borrowNo;

  private Long authUserId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("company_id", companyId);
      map.put("org_id", orgId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("status", status);
      map.put("flow_no", flowNo);
      map.put("borrow_user_code", borrowUserCode);
      map.put("borrow_username", borrowUsername);
      map.put("company_name", companyName);
      map.put("department_name", departmentName);
      map.put("borrow_phone", borrowPhone);
      map.put("borrow_mail", borrowMail);
      map.put("position", position);
      map.put("apply_start_time", BocpGenUtils.toTimestamp(applyStartTime));
      map.put("apply_end_time", BocpGenUtils.toTimestamp(applyEndTime));
      map.put("reason", reason);
      map.put("content", content);
      map.put("file_type", fileType);
      map.put("type", type);
      map.put("address", address);
      map.put("remark", remark);
      map.put("auth_time", BocpGenUtils.toTimestamp(authTime));
      map.put("auth_types", authTypes);
      map.put("auth_username", authUsername);
      map.put("borrow_time", BocpGenUtils.toTimestamp(borrowTime));
      map.put("return_time", BocpGenUtils.toTimestamp(returnTime));
      map.put("borrow_lend_username", borrowLendUsername);
      map.put("lose_flag", loseFlag);
      map.put("overdue_flag", overdueFlag);
      map.put("borrow_situation", borrowSituation);
      map.put("borrow_duration", borrowDuration);
      map.put("borrow_user_id", borrowUserId);
      map.put("approval_business_key", approvalBusinessKey);
      map.put("approval_pending_user_id", approvalPendingUserId);
      map.put("approval_process_info", approvalProcessInfo);
      map.put("approval_reject_flag", approvalRejectFlag);
      map.put("approval_reject_remark", approvalRejectRemark);
      map.put("approval_status", approvalStatus);
      map.put("approval_reject_time", BocpGenUtils.toTimestamp(approvalRejectTime));
      map.put("approval_rejecter", approvalRejecter);
      map.put("channel", channel);
      map.put("borrow_no", borrowNo);
      map.put("auth_user_id", authUserId);
      return map;
  }

  public static BorrowApplyInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BorrowApplyInfo entity = new BorrowApplyInfo();
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flow_no")) {
      Object obj = map.get("flow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_user_code")) {
      Object obj = map.get("borrow_user_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_username")) {
      Object obj = map.get("borrow_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("department_name")) {
      Object obj = map.get("department_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_phone")) {
      Object obj = map.get("borrow_phone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_mail")) {
      Object obj = map.get("borrow_mail");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowMail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("position")) {
      Object obj = map.get("position");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPosition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_start_time")) {
      Object obj = map.get("apply_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyStartTime(null);
      }
    }
    if(map.containsKey("apply_end_time")) {
      Object obj = map.get("apply_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyEndTime(null);
      }
    }
    if(map.containsKey("reason")) {
      Object obj = map.get("reason");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("content")) {
      Object obj = map.get("content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_type")) {
      Object obj = map.get("file_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_time")) {
      Object obj = map.get("auth_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setAuthTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setAuthTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuthTime(null);
      }
    }
    if(map.containsKey("auth_types")) {
      Object obj = map.get("auth_types");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthTypes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_username")) {
      Object obj = map.get("auth_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_time")) {
      Object obj = map.get("borrow_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setBorrowTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setBorrowTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBorrowTime(null);
      }
    }
    if(map.containsKey("return_time")) {
      Object obj = map.get("return_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setReturnTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReturnTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReturnTime(null);
      }
    }
    if(map.containsKey("borrow_lend_username")) {
      Object obj = map.get("borrow_lend_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowLendUsername((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("overdue_flag")) {
      Object obj = map.get("overdue_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOverdueFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_duration")) {
      Object obj = map.get("borrow_duration");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_user_id")) {
      Object obj = map.get("borrow_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBorrowUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBorrowUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setBorrowUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("approval_business_key")) {
      Object obj = map.get("approval_business_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalBusinessKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_pending_user_id")) {
      Object obj = map.get("approval_pending_user_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalPendingUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_process_info")) {
      Object obj = map.get("approval_process_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalProcessInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_flag")) {
      Object obj = map.get("approval_reject_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_remark")) {
      Object obj = map.get("approval_reject_remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejectRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_status")) {
      Object obj = map.get("approval_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("approval_reject_time")) {
      Object obj = map.get("approval_reject_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApprovalRejectTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApprovalRejectTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApprovalRejectTime(null);
      }
    }
    if(map.containsKey("approval_rejecter")) {
      Object obj = map.get("approval_rejecter");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApprovalRejecter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channel")) {
      Object obj = map.get("channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("borrow_no")) {
      Object obj = map.get("borrow_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auth_user_id")) {
      Object obj = map.get("auth_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuthUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAuthUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAuthUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    return entity;
  }
}
