package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ConfigAccountDataType implements Serializable {

  private static final long serialVersionUID=1L;

  private String custodyFormType;

  private String repeatField;

  private Long tenant;

  private Long orgId;

  private String orgName;

  private Long term;

  private String businessType;

  private String downloadInvoiceType;

  private String typeName;

  private String typeNo;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String dataObjectType;

  private String biSwitch;

  private String concreteObjectType;

  private String concreteObjectProperty;

  private String downloadFlag;

  private String notEmptyField;

  private String enable;

  private String isDefault;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("custody_form_type", custodyFormType);
      map.put("repeat_field", repeatField);
      map.put("tenant", tenant);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("term", term);
      map.put("business_type", businessType);
      map.put("download_invoice_type", downloadInvoiceType);
      map.put("type_name", typeName);
      map.put("type_no", typeNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("data_object_type", dataObjectType);
      map.put("bi_switch", biSwitch);
      map.put("concrete_object_type", concreteObjectType);
      map.put("concrete_object_property", concreteObjectProperty);
      map.put("download_flag", downloadFlag);
      map.put("not_empty_field", notEmptyField);
      map.put("enable", enable);
      map.put("is_default", isDefault);
      return map;
  }

  public static ConfigAccountDataType fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ConfigAccountDataType entity = new ConfigAccountDataType();
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("repeat_field")) {
      Object obj = map.get("repeat_field");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRepeatField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant")) {
      Object obj = map.get("tenant");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenant((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenant(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenant(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("term")) {
      Object obj = map.get("term");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTerm((Long)obj);
        } else if(obj instanceof String) {
          entity.setTerm(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTerm(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_invoice_type")) {
      Object obj = map.get("download_invoice_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type_name")) {
      Object obj = map.get("type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type_no")) {
      Object obj = map.get("type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("data_object_type")) {
      Object obj = map.get("data_object_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataObjectType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bi_switch")) {
      Object obj = map.get("bi_switch");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBiSwitch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("concrete_object_type")) {
      Object obj = map.get("concrete_object_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConcreteObjectType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("concrete_object_property")) {
      Object obj = map.get("concrete_object_property");
      if(obj != null) {
        if(obj instanceof String){
          entity.setConcreteObjectProperty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("download_flag")) {
      Object obj = map.get("download_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDownloadFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("not_empty_field")) {
      Object obj = map.get("not_empty_field");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNotEmptyField((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enable")) {
      Object obj = map.get("enable");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnable((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_default")) {
      Object obj = map.get("is_default");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDefault((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
