package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.elephantarchives.entity.OriginalTicket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-10-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketToll extends OriginalTicket {


  private String exitPlace;

  private String entrancePlace;

  private String date;

  private String payment;

  private String vehiclesType;

  private BigDecimal totalAmount;

  private String vehiclesWeight;

  private String tollLimit;

  private String time;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("exit_place", exitPlace);
      map.put("entrance_place", entrancePlace);
      map.put("date", date);
      map.put("payment", payment);
      map.put("vehicles_type", vehiclesType);
      map.put("total_amount", totalAmount);
      map.put("vehicles_weight", vehiclesWeight);
      map.put("toll_limit", tollLimit);
      map.put("time", time);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static TicketToll fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketToll entity = new TicketToll();
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("company_code")) {
      Object obj = map.get("company_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("orig_system")) {
      Object obj = map.get("orig_system");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrigSystem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_flag")) {
      Object obj = map.get("sensitive_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lose_flag")) {
      Object obj = map.get("lose_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoseFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_flag")) {
      Object obj = map.get("exception_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_flag")) {
      Object obj = map.get("warning_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_status")) {
      Object obj = map.get("material_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount_with_tax")) {
      Object obj = map.get("amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amount_without_tax")) {
      Object obj = map.get("amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_amount")) {
      Object obj = map.get("tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_status")) {
      Object obj = map.get("borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("img_url")) {
      Object obj = map.get("img_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setImgUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sensitive_situation")) {
      Object obj = map.get("sensitive_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSensitiveSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material_situation")) {
      Object obj = map.get("material_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("borrow_situation")) {
      Object obj = map.get("borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBorrowSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sorting_status")) {
      Object obj = map.get("sorting_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSortingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_id")) {
      Object obj = map.get("account_data_type_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAccountDataTypeId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAccountDataTypeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setAccountDataTypeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_name")) {
      Object obj = map.get("account_data_type_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_data_type_no")) {
      Object obj = map.get("account_data_type_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAccountDataTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custody_form_type")) {
      Object obj = map.get("custody_form_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustodyFormType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_type")) {
      Object obj = map.get("exception_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExceptionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_username")) {
      Object obj = map.get("scan_username");
      if(obj != null) {
        if(obj instanceof String){
          entity.setScanUsername((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_time")) {
      Object obj = map.get("scan_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScanTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setScanTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        entity.setScanTime(null);
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_borrow_situation")) {
      Object obj = map.get("paper_borrow_situation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowSituation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paper_borrow_status")) {
      Object obj = map.get("paper_borrow_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaperBorrowStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("custody_year")) {
      Object obj = map.get("custody_year");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCustodyYear((Long)obj);
        } else if(obj instanceof String) {
          entity.setCustodyYear(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCustodyYear(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("exit_place")) {
      Object obj = map.get("exit_place");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExitPlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entrance_place")) {
      Object obj = map.get("entrance_place");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntrancePlace((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date")) {
      Object obj = map.get("date");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payment")) {
      Object obj = map.get("payment");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vehicles_type")) {
      Object obj = map.get("vehicles_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehiclesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_amount")) {
      Object obj = map.get("total_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("vehicles_weight")) {
      Object obj = map.get("vehicles_weight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVehiclesWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toll_limit")) {
      Object obj = map.get("toll_limit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTollLimit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
