package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 币种
 * </p>
 *
 * @author ultraman
 * @since 2021-10-12
 */
public enum Currency {

    CNY("CNY", "人民币"),
    USD("USD", "美元"),
    EUR("EUR", "欧元");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Currency(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Currency fromCode(String code){
        switch(code) {
            case "CNY":
                return CNY;
            case "USD":
                return USD;
            case "EUR":
                return EUR;
            default:
                return null;
        }
    }
}
