package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 规则编号
 * </p>
 *
 * @author ultraman
 * @since 2021-10-12
 */
public enum ExceptionRuleCode {

    A1001("A1001", "关系未挂接"),
    A1002("A1002", "文件加密转储失败"),
    A1003("A1003", "源文件校验规则"),
    R1001("R1001", "档案类型校验规则"),
    R1002("R1002", "档案下包含异常资料"),
    R1003("R1003", "档案下包含预警资料"),
    A1004("A1004", "资料演示规则"),
    R1004("R1004", "档案演示规则");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExceptionRuleCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExceptionRuleCode fromCode(String code){
        switch(code) {
            case "A1001":
                return A1001;
            case "A1002":
                return A1002;
            case "A1003":
                return A1003;
            case "R1001":
                return R1001;
            case "R1002":
                return R1002;
            case "R1003":
                return R1003;
            case "A1004":
                return A1004;
            case "R1004":
                return R1004;
            default:
                return null;
        }
    }
}
