package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 验真状态
 * </p>
 *
 * @author ultraman
 * @since 2021-10-12
 */
public enum TickerCheckStatus {

    __1("-1", "验真失败"),
    _0("0", "未验真"),
    _1("1", "验真中"),
    _2("2", "验真成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TickerCheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TickerCheckStatus fromCode(String code){
        switch(code) {
            case "-1":
                return __1;
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
