package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型
 * </p>
 *
 * @author ultraman
 * @since 2021-10-21
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    CE("ce", "增值税电子普通发票"),
    J("j", "机动车销售统一发票"),
    CJ("cj", "增值税普通发票（卷票)"),
    SE("se", "增值税电子专用发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    CB("cb", "增值税电子普通发票（区块链）"),
    CD("cd", "浙江通用（电子）发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "ce":
                return CE;
            case "j":
                return J;
            case "cj":
                return CJ;
            case "se":
                return SE;
            case "ct":
                return CT;
            case "cb":
                return CB;
            case "cd":
                return CD;
            default:
                return null;
        }
    }
}
