package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测项目
 * </p>
 *
 * @author ultraman
 * @since 2021-11-09
 */
public enum DetectionProject {

    REALITY("reality", "真实性"),
    COMPLETE("complete", "完整性"),
    AVAILABILITY("availability", "可用性"),
    SAFETY("safety", "安全性"),
    CUSTOMIZE("customize", "自定义");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DetectionProject(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DetectionProject fromCode(String code){
        switch(code) {
            case "reality":
                return REALITY;
            case "complete":
                return COMPLETE;
            case "availability":
                return AVAILABILITY;
            case "safety":
                return SAFETY;
            case "customize":
                return CUSTOMIZE;
            default:
                return null;
        }
    }
}
