package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测状态
 * </p>
 *
 * @author ultraman
 * @since 2021-11-09
 */
public enum DetectionStatus {

    _0("0", "暂不具备检测条件"),
    _1("1", "检测通过"),
    __1("-1", "检测不通过"),
    _2("2", "检测中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DetectionStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DetectionStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "-1":
                return __1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
