package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案对象类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-07
 */
public enum ArchivesType {

    _0("0", "分册"),
    _1("1", "凭证"),
    _2("2", "单据"),
    _3("3", "单证"),
    _4("4", "附件"),
    _13("13", "非凭证类");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ArchivesType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ArchivesType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "13":
                return _13;
            default:
                return null;
        }
    }
}
