package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 检测类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-07
 */
public enum DetectionType {

    _1("1", "四性检测	");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DetectionType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DetectionType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
