package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 分册校验项
 * </p>
 *
 * @author ultraman
 * @since 2022-01-07
 */
public enum VolumeCheck {

    TENANT_ID("tenant_id", "租户维度"),
    ORG_ID("org_id", "公司维度"),
    ARCHIVE_TYPE_ID("archive_type_id", "档案类型");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VolumeCheck(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VolumeCheck fromCode(String code){
        switch(code) {
            case "tenant_id":
                return TENANT_ID;
            case "org_id":
                return ORG_ID;
            case "archive_type_id":
                return ARCHIVE_TYPE_ID;
            default:
                return null;
        }
    }
}
