package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 三大类档案文件
 * </p>
 *
 * @author ultraman
 * @since 2022-01-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ArchiveFile implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 文件名称
   */
  private String fileName;

  /**
   * 文件后缀名
   */
  private String fileExt;

  /**
   * 上传时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime uploadTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 操作人
   */
  private String userName;

  /**
   * 文件可访问地址
   */
  private String fileUrl;

  /**
   * 文件key(用于删除)
   */
  private String fileKey;

  /**
   * 对象主键id
   */
  private Long entityId;

  /**
   * 对象编号
   */
  private String entityType;

  /**
   * 密文
   */
  private String cipher;

  /**
   * 加密方式
   */
  private String encryptionMethod;

  /**
   * 转储oss地址
   */
  private String dumpOssUrl;

  /**
   * 加密状态
   */
  private String encryptionStatus;

  /**
   * 转储密文
   */
  private String dumpCipher;

  /**
   * 排序序列
   */
  private Long sequence;

  /**
   * 是否转储
   */
  private String dumpFlag;

  /**
   * 转储文件key(用于删除)
   */
  private String dumpOssKey;

  /**
   * 样式小类代码
   */
  private String styleSmallCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("file_name", fileName);
      map.put("file_ext", fileExt);
      map.put("upload_time", BocpGenUtils.toTimestamp(uploadTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("user_name", userName);
      map.put("file_url", fileUrl);
      map.put("file_key", fileKey);
      map.put("entity_id", entityId);
      map.put("entity_type", entityType);
      map.put("cipher", cipher);
      map.put("encryption_method", encryptionMethod);
      map.put("dump_oss_url", dumpOssUrl);
      map.put("encryption_status", encryptionStatus);
      map.put("dump_cipher", dumpCipher);
      map.put("sequence", sequence);
      map.put("dump_flag", dumpFlag);
      map.put("dump_oss_key", dumpOssKey);
      map.put("style_small_code", styleSmallCode);
      return map;
  }

  public static ArchiveFile fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ArchiveFile entity = new ArchiveFile();
    if(map.containsKey("file_name")) {
      Object obj = map.get("file_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_ext")) {
      Object obj = map.get("file_ext");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileExt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upload_time")) {
      Object obj = map.get("upload_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUploadTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUploadTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUploadTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUploadTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_name")) {
      Object obj = map.get("user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_url")) {
      Object obj = map.get("file_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("file_key")) {
      Object obj = map.get("file_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFileKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entity_id")) {
      Object obj = map.get("entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntityId((Long)obj);
        } else if(obj instanceof String) {
          entity.setEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setEntityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("entity_type")) {
      Object obj = map.get("entity_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipher")) {
      Object obj = map.get("cipher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCipher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_method")) {
      Object obj = map.get("encryption_method");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dump_oss_url")) {
      Object obj = map.get("dump_oss_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDumpOssUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("encryption_status")) {
      Object obj = map.get("encryption_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEncryptionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dump_cipher")) {
      Object obj = map.get("dump_cipher");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDumpCipher((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sequence")) {
      Object obj = map.get("sequence");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSequence((Long)obj);
        } else if(obj instanceof String) {
          entity.setSequence(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSequence(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("dump_flag")) {
      Object obj = map.get("dump_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDumpFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dump_oss_key")) {
      Object obj = map.get("dump_oss_key");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDumpOssKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("style_small_code")) {
      Object obj = map.get("style_small_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStyleSmallCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
