package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据小类
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum BillSubType {

    _1("1", "预付单PP"),
    _0("0", "接收单RT"),
    _2("2", "差旅报销单"),
    _3("3", "费用报销单"),
    _4("4", "对账单"),
    _5("5", "开票单"),
    _6("6", "付款申请单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillSubType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillSubType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "0":
                return _0;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
