package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 借阅渠道
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum BorrowChannel {

    ARTIFICIAL("artificial", "人工登记"),
    OA("oa", "OA申请"),
    ARCHIVE("archive", "档案系统");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BorrowChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BorrowChannel fromCode(String code){
        switch(code) {
            case "artificial":
                return ARTIFICIAL;
            case "oa":
                return OA;
            case "archive":
                return ARCHIVE;
            default:
                return null;
        }
    }
}
