package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 加密方式
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum EncryptionMethod {

    MD5("MD5", "MD5"),
    SHA_256("SHA-256", "SHA-256"),
    SHA_512("SHA-512", "SHA-512");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EncryptionMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EncryptionMethod fromCode(String code){
        switch(code) {
            case "MD5":
                return MD5;
            case "SHA-256":
                return SHA_256;
            case "SHA-512":
                return SHA_512;
            default:
                return null;
        }
    }
}
