package com.xforceplus.ultraman.app.elephantarchives.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 档案类型周期
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
public enum TypePeriod {

    NONE("none", "无"),
    MONTH("month", "月"),
    QUARTER("quarter", "季度"),
    HALF_YEAR("half_year", "半年度"),
    YEAR("year", "年度");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TypePeriod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TypePeriod fromCode(String code){
        switch(code) {
            case "none":
                return NONE;
            case "month":
                return MONTH;
            case "quarter":
                return QUARTER;
            case "half_year":
                return HALF_YEAR;
            case "year":
                return YEAR;
            default:
                return null;
        }
    }
}
