package com.xforceplus.ultraman.app.elephantarchives.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 四性检测
 * </p>
 *
 * @author ultraman
 * @since 2022-03-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Detection implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 检测状态
   */
  private String detectionStatus;

  /**
   * 检测人
   */
  private String detectionUser;

  /**
   * 检测结束时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime detectionEndTime;

  /**
   * 检测开始时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime detectionStartTime;

  /**
   * zip地址
   */
  private String zipUrl;

  /**
   * zip名称
   */
  private String zipName;

  /**
   * 检测报告地址
   */
  private String pdfUrl;

  /**
   * 检测报告名称
   */
  private String pdfName;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 检测结果
   */
  private String detectionResult;

  /**
   * 摘要
   */
  private String abstractText;

  /**
   * 归档信息包id
   */
  private String archivePackageId;

  /**
   * 检测内容	
   */
  private String detectionContent;

  /**
   * 检测类型
   */
  private String detectionType;

  /**
   * 检测环节
   */
  private String detectionLink;

  /**
   * 检测方式
   */
  private String detectionMode;

  /**
   * 资料id
   */
  private Long entityId;

  /**
   * 资料类型
   */
  private String entityType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("detection_status", detectionStatus);
      map.put("detection_user", detectionUser);
      map.put("detection_end_time", BocpGenUtils.toTimestamp(detectionEndTime));
      map.put("detection_start_time", BocpGenUtils.toTimestamp(detectionStartTime));
      map.put("zip_url", zipUrl);
      map.put("zip_name", zipName);
      map.put("pdf_url", pdfUrl);
      map.put("pdf_name", pdfName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("detection_result", detectionResult);
      map.put("abstract_text", abstractText);
      map.put("archive_package_id", archivePackageId);
      map.put("detection_content", detectionContent);
      map.put("detection_type", detectionType);
      map.put("detection_link", detectionLink);
      map.put("detection_mode", detectionMode);
      map.put("entity_id", entityId);
      map.put("entity_type", entityType);
      return map;
  }

  public static Detection fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Detection entity = new Detection();
    if(map.containsKey("detection_status")) {
      Object obj = map.get("detection_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_user")) {
      Object obj = map.get("detection_user");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_end_time")) {
      Object obj = map.get("detection_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetectionEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDetectionEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDetectionEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDetectionEndTime(null);
      }
    }
    if(map.containsKey("detection_start_time")) {
      Object obj = map.get("detection_start_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDetectionStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDetectionStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDetectionStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDetectionStartTime(null);
      }
    }
    if(map.containsKey("zip_url")) {
      Object obj = map.get("zip_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZipUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zip_name")) {
      Object obj = map.get("zip_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZipName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdf_url")) {
      Object obj = map.get("pdf_url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdf_name")) {
      Object obj = map.get("pdf_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_result")) {
      Object obj = map.get("detection_result");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abstract_text")) {
      Object obj = map.get("abstract_text");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAbstractText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("archive_package_id")) {
      Object obj = map.get("archive_package_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArchivePackageId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_content")) {
      Object obj = map.get("detection_content");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_type")) {
      Object obj = map.get("detection_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_link")) {
      Object obj = map.get("detection_link");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionLink((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detection_mode")) {
      Object obj = map.get("detection_mode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDetectionMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entity_id")) {
      Object obj = map.get("entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntityId((Long)obj);
        } else if(obj instanceof String) {
          entity.setEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setEntityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("entity_type")) {
      Object obj = map.get("entity_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEntityType((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
