package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveDirectory;
import com.xforceplus.ultraman.app.elephantarchives.service.IArchiveDirectoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-09
 */
@RestController
public class ArchiveDirectoryController {

  @Autowired
  private IArchiveDirectoryService archiveDirectoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveDirectory ${table.comment}
   * @return
   */
  @GetMapping("/archivedirectorys" )
  public XfR getArchiveDirectorys(XfPage page, ArchiveDirectory archiveDirectory) {
    return XfR.ok(archiveDirectoryServiceImpl.page(page, Wrappers.query(archiveDirectory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/archivedirectorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveDirectoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param archiveDirectory ${table.comment}
   * @return XfR
   */
  @PostMapping("/archivedirectorys")
  public XfR save(@RequestBody ArchiveDirectory archiveDirectory) {
     return XfR.ok(archiveDirectoryServiceImpl.save(archiveDirectory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param archiveDirectory ${table.comment}
   * @return XfR
   */
  @PutMapping("/archivedirectorys/{id}")
  public XfR putUpdate(@RequestBody ArchiveDirectory archiveDirectory,@PathVariable Long id) {
      archiveDirectory.setId(id);
      return XfR.ok(archiveDirectoryServiceImpl.updateById(archiveDirectory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param archiveDirectory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/archivedirectorys/{id}")
  public XfR patchUpdate(@RequestBody ArchiveDirectory archiveDirectory,@PathVariable Long id) {
      ArchiveDirectory uparchiveDirectory = archiveDirectoryServiceImpl.getById(id);
      if(uparchiveDirectory != null){
        uparchiveDirectory = ObjectCopyUtils.copyProperties(archiveDirectory,uparchiveDirectory,true);
      }
      return XfR.ok(archiveDirectoryServiceImpl.updateById(uparchiveDirectory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archivedirectorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveDirectoryServiceImpl.removeById(id));
  }

  @PostMapping("/archivedirectorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_directory");
     params.put("request", condition);

     return XfR.ok(archiveDirectoryServiceImpl.querys(params));
  }

}
