package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeOperateLog;
import com.xforceplus.ultraman.app.elephantarchives.service.IVolumeOperateLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-09
 */
@RestController
public class VolumeOperateLogController {

  @Autowired
  private IVolumeOperateLogService volumeOperateLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volumeOperateLog ${table.comment}
   * @return
   */
  @GetMapping("/volumeoperatelogs" )
  public XfR getVolumeOperateLogs(XfPage page, VolumeOperateLog volumeOperateLog) {
    return XfR.ok(volumeOperateLogServiceImpl.page(page, Wrappers.query(volumeOperateLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumeoperatelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumeOperateLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param volumeOperateLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/volumeoperatelogs")
  public XfR save(@RequestBody VolumeOperateLog volumeOperateLog) {
     return XfR.ok(volumeOperateLogServiceImpl.save(volumeOperateLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param volumeOperateLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/volumeoperatelogs/{id}")
  public XfR putUpdate(@RequestBody VolumeOperateLog volumeOperateLog,@PathVariable Long id) {
      volumeOperateLog.setId(id);
      return XfR.ok(volumeOperateLogServiceImpl.updateById(volumeOperateLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param volumeOperateLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/volumeoperatelogs/{id}")
  public XfR patchUpdate(@RequestBody VolumeOperateLog volumeOperateLog,@PathVariable Long id) {
      VolumeOperateLog upvolumeOperateLog = volumeOperateLogServiceImpl.getById(id);
      if(upvolumeOperateLog != null){
        upvolumeOperateLog = ObjectCopyUtils.copyProperties(volumeOperateLog,upvolumeOperateLog,true);
      }
      return XfR.ok(volumeOperateLogServiceImpl.updateById(upvolumeOperateLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumeoperatelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumeOperateLogServiceImpl.removeById(id));
  }

  @PostMapping("/volumeoperatelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume_operate_log");
     params.put("request", condition);

     return XfR.ok(volumeOperateLogServiceImpl.querys(params));
  }

}
