package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ConfigSettings;
import com.xforceplus.ultraman.app.elephantarchives.service.IConfigSettingsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-13
 */
@RestController
public class ConfigSettingsController {

  @Autowired
  private IConfigSettingsService configSettingsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configSettings ${table.comment}
   * @return
   */
  @GetMapping("/configsettingss" )
  public XfR getConfigSettingss(XfPage page, ConfigSettings configSettings) {
    return XfR.ok(configSettingsServiceImpl.page(page, Wrappers.query(configSettings)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configsettingss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configSettingsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configSettings ${table.comment}
   * @return XfR
   */
  @PostMapping("/configsettingss")
  public XfR save(@RequestBody ConfigSettings configSettings) {
     return XfR.ok(configSettingsServiceImpl.save(configSettings));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configSettings ${table.comment}
   * @return XfR
   */
  @PutMapping("/configsettingss/{id}")
  public XfR putUpdate(@RequestBody ConfigSettings configSettings,@PathVariable Long id) {
      configSettings.setId(id);
      return XfR.ok(configSettingsServiceImpl.updateById(configSettings));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configSettings ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configsettingss/{id}")
  public XfR patchUpdate(@RequestBody ConfigSettings configSettings,@PathVariable Long id) {
      ConfigSettings upconfigSettings = configSettingsServiceImpl.getById(id);
      if(upconfigSettings != null){
        upconfigSettings = ObjectCopyUtils.copyProperties(configSettings,upconfigSettings,true);
      }
      return XfR.ok(configSettingsServiceImpl.updateById(upconfigSettings));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configsettingss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configSettingsServiceImpl.removeById(id));
  }

  @PostMapping("/configsettingss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_settings");
     params.put("request", condition);

     return XfR.ok(configSettingsServiceImpl.querys(params));
  }

}
