package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Warehouse;
import com.xforceplus.ultraman.app.elephantarchives.service.IWarehouseService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-13
 */
@RestController
public class WarehouseController {

  @Autowired
  private IWarehouseService warehouseServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param warehouse ${table.comment}
   * @return
   */
  @GetMapping("/warehouses" )
  public XfR getWarehouses(XfPage page, Warehouse warehouse) {
    return XfR.ok(warehouseServiceImpl.page(page, Wrappers.query(warehouse)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/warehouses/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(warehouseServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param warehouse ${table.comment}
   * @return XfR
   */
  @PostMapping("/warehouses")
  public XfR save(@RequestBody Warehouse warehouse) {
     return XfR.ok(warehouseServiceImpl.save(warehouse));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param warehouse ${table.comment}
   * @return XfR
   */
  @PutMapping("/warehouses/{id}")
  public XfR putUpdate(@RequestBody Warehouse warehouse,@PathVariable Long id) {
      warehouse.setId(id);
      return XfR.ok(warehouseServiceImpl.updateById(warehouse));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param warehouse ${table.comment}
   * @return XfR
   */
  @PatchMapping("/warehouses/{id}")
  public XfR patchUpdate(@RequestBody Warehouse warehouse,@PathVariable Long id) {
      Warehouse upwarehouse = warehouseServiceImpl.getById(id);
      if(upwarehouse != null){
        upwarehouse = ObjectCopyUtils.copyProperties(warehouse,upwarehouse,true);
      }
      return XfR.ok(warehouseServiceImpl.updateById(upwarehouse));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/warehouses/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(warehouseServiceImpl.removeById(id));
  }

  @PostMapping("/warehouses/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "warehouse");
     params.put("request", condition);

     return XfR.ok(warehouseServiceImpl.querys(params));
  }

}
