package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BillImport;
import com.xforceplus.ultraman.app.elephantarchives.service.IBillImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-10-09
 */
@RestController
public class BillImportController {

  @Autowired
  private IBillImportService billImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billImport ${table.comment}
   * @return
   */
  @GetMapping("/billimports" )
  public XfR getBillImports(XfPage page, BillImport billImport) {
    return XfR.ok(billImportServiceImpl.page(page, Wrappers.query(billImport)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billImportServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billImport ${table.comment}
   * @return XfR
   */
  @PostMapping("/billimports")
  public XfR save(@RequestBody BillImport billImport) {
     return XfR.ok(billImportServiceImpl.save(billImport));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billImport ${table.comment}
   * @return XfR
   */
  @PutMapping("/billimports/{id}")
  public XfR putUpdate(@RequestBody BillImport billImport,@PathVariable Long id) {
      billImport.setId(id);
      return XfR.ok(billImportServiceImpl.updateById(billImport));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billImport ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billimports/{id}")
  public XfR patchUpdate(@RequestBody BillImport billImport,@PathVariable Long id) {
      BillImport upbillImport = billImportServiceImpl.getById(id);
      if(upbillImport != null){
        upbillImport = ObjectCopyUtils.copyProperties(billImport,upbillImport,true);
      }
      return XfR.ok(billImportServiceImpl.updateById(upbillImport));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billImportServiceImpl.removeById(id));
  }

  @PostMapping("/billimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_import");
     params.put("request", condition);

     return XfR.ok(billImportServiceImpl.querys(params));
  }

}
