package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TransferOperation;
import com.xforceplus.ultraman.app.elephantarchives.service.ITransferOperationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-10-09
 */
@RestController
public class TransferOperationController {

  @Autowired
  private ITransferOperationService transferOperationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param transferOperation ${table.comment}
   * @return
   */
  @GetMapping("/transferoperations" )
  public XfR getTransferOperations(XfPage page, TransferOperation transferOperation) {
    return XfR.ok(transferOperationServiceImpl.page(page, Wrappers.query(transferOperation)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/transferoperations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(transferOperationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param transferOperation ${table.comment}
   * @return XfR
   */
  @PostMapping("/transferoperations")
  public XfR save(@RequestBody TransferOperation transferOperation) {
     return XfR.ok(transferOperationServiceImpl.save(transferOperation));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param transferOperation ${table.comment}
   * @return XfR
   */
  @PutMapping("/transferoperations/{id}")
  public XfR putUpdate(@RequestBody TransferOperation transferOperation,@PathVariable Long id) {
      transferOperation.setId(id);
      return XfR.ok(transferOperationServiceImpl.updateById(transferOperation));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param transferOperation ${table.comment}
   * @return XfR
   */
  @PatchMapping("/transferoperations/{id}")
  public XfR patchUpdate(@RequestBody TransferOperation transferOperation,@PathVariable Long id) {
      TransferOperation uptransferOperation = transferOperationServiceImpl.getById(id);
      if(uptransferOperation != null){
        uptransferOperation = ObjectCopyUtils.copyProperties(transferOperation,uptransferOperation,true);
      }
      return XfR.ok(transferOperationServiceImpl.updateById(uptransferOperation));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/transferoperations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(transferOperationServiceImpl.removeById(id));
  }

  @PostMapping("/transferoperations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "transfer_operation");
     params.put("request", condition);

     return XfR.ok(transferOperationServiceImpl.querys(params));
  }

}
