package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ValudationRuleConfig;
import com.xforceplus.ultraman.app.elephantarchives.service.IValudationRuleConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-10-09
 */
@RestController
public class ValudationRuleConfigController {

  @Autowired
  private IValudationRuleConfigService valudationRuleConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param valudationRuleConfig ${table.comment}
   * @return
   */
  @GetMapping("/valudationruleconfigs" )
  public XfR getValudationRuleConfigs(XfPage page, ValudationRuleConfig valudationRuleConfig) {
    return XfR.ok(valudationRuleConfigServiceImpl.page(page, Wrappers.query(valudationRuleConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/valudationruleconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(valudationRuleConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param valudationRuleConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/valudationruleconfigs")
  public XfR save(@RequestBody ValudationRuleConfig valudationRuleConfig) {
     return XfR.ok(valudationRuleConfigServiceImpl.save(valudationRuleConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param valudationRuleConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/valudationruleconfigs/{id}")
  public XfR putUpdate(@RequestBody ValudationRuleConfig valudationRuleConfig,@PathVariable Long id) {
      valudationRuleConfig.setId(id);
      return XfR.ok(valudationRuleConfigServiceImpl.updateById(valudationRuleConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param valudationRuleConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/valudationruleconfigs/{id}")
  public XfR patchUpdate(@RequestBody ValudationRuleConfig valudationRuleConfig,@PathVariable Long id) {
      ValudationRuleConfig upvaludationRuleConfig = valudationRuleConfigServiceImpl.getById(id);
      if(upvaludationRuleConfig != null){
        upvaludationRuleConfig = ObjectCopyUtils.copyProperties(valudationRuleConfig,upvaludationRuleConfig,true);
      }
      return XfR.ok(valudationRuleConfigServiceImpl.updateById(upvaludationRuleConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/valudationruleconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(valudationRuleConfigServiceImpl.removeById(id));
  }

  @PostMapping("/valudationruleconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "valudation_rule_config");
     params.put("request", condition);

     return XfR.ok(valudationRuleConfigServiceImpl.querys(params));
  }

}
