package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ApprovalOperateLog;
import com.xforceplus.ultraman.app.elephantarchives.service.IApprovalOperateLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 审批相关操作日志前端控制器
 *
 * @author ultraman
 * @date 2021-10-16
 */
@RestController
public class ApprovalOperateLogController {

  @Autowired
  private IApprovalOperateLogService approvalOperateLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param approvalOperateLog 审批相关操作日志
   * @return
   */
  @GetMapping("/approvaloperatelogs" )
  public XfR getApprovalOperateLogs(XfPage page, ApprovalOperateLog approvalOperateLog) {
    return XfR.ok(approvalOperateLogServiceImpl.page(page, Wrappers.query(approvalOperateLog)));
  }

  /**
   * 通过id查询审批相关操作日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/approvaloperatelogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(approvalOperateLogServiceImpl.getById(id));
  }

  /**
   * 新增审批相关操作日志
   * @param approvalOperateLog 审批相关操作日志
   * @return XfR
   */
  @PostMapping("/approvaloperatelogs")
  public XfR save(@RequestBody ApprovalOperateLog approvalOperateLog) {
     return XfR.ok(approvalOperateLogServiceImpl.save(approvalOperateLog));
  }

  /**
   * 修改-传入修改后的全部数据审批相关操作日志
   * @param approvalOperateLog 审批相关操作日志
   * @return XfR
   */
  @PutMapping("/approvaloperatelogs/{id}")
  public XfR putUpdate(@RequestBody ApprovalOperateLog approvalOperateLog,@PathVariable Long id) {
      approvalOperateLog.setId(id);
      return XfR.ok(approvalOperateLogServiceImpl.updateById(approvalOperateLog));
  }

  /**
   * 修改-传入修改的数据审批相关操作日志
   * @param approvalOperateLog 审批相关操作日志
   * @return XfR
   */
  @PatchMapping("/approvaloperatelogs/{id}")
  public XfR patchUpdate(@RequestBody ApprovalOperateLog approvalOperateLog,@PathVariable Long id) {
      ApprovalOperateLog upapprovalOperateLog = approvalOperateLogServiceImpl.getById(id);
      if(upapprovalOperateLog != null){
        upapprovalOperateLog = ObjectCopyUtils.copyProperties(approvalOperateLog,upapprovalOperateLog,true);
      }
      return XfR.ok(approvalOperateLogServiceImpl.updateById(upapprovalOperateLog));
  }

  /**
   * 通过id删除审批相关操作日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/approvaloperatelogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(approvalOperateLogServiceImpl.removeById(id));
  }

  @PostMapping("/approvaloperatelogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "approval_operate_log");
     params.put("request", condition);

     return XfR.ok(approvalOperateLogServiceImpl.querys(params));
  }

}
