package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.AttachmentImport;
import com.xforceplus.ultraman.app.elephantarchives.service.IAttachmentImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 附件查询导入模板前端控制器
 *
 * @author ultraman
 * @date 2021-10-16
 */
@RestController
public class AttachmentImportController {

  @Autowired
  private IAttachmentImportService attachmentImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param attachmentImport 附件查询导入模板
   * @return
   */
  @GetMapping("/attachmentimports" )
  public XfR getAttachmentImports(XfPage page, AttachmentImport attachmentImport) {
    return XfR.ok(attachmentImportServiceImpl.page(page, Wrappers.query(attachmentImport)));
  }

  /**
   * 通过id查询附件查询导入模板
   * @param  id
   * @return XfR
   */
  @GetMapping("/attachmentimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(attachmentImportServiceImpl.getById(id));
  }

  /**
   * 新增附件查询导入模板
   * @param attachmentImport 附件查询导入模板
   * @return XfR
   */
  @PostMapping("/attachmentimports")
  public XfR save(@RequestBody AttachmentImport attachmentImport) {
     return XfR.ok(attachmentImportServiceImpl.save(attachmentImport));
  }

  /**
   * 修改-传入修改后的全部数据附件查询导入模板
   * @param attachmentImport 附件查询导入模板
   * @return XfR
   */
  @PutMapping("/attachmentimports/{id}")
  public XfR putUpdate(@RequestBody AttachmentImport attachmentImport,@PathVariable Long id) {
      attachmentImport.setId(id);
      return XfR.ok(attachmentImportServiceImpl.updateById(attachmentImport));
  }

  /**
   * 修改-传入修改的数据附件查询导入模板
   * @param attachmentImport 附件查询导入模板
   * @return XfR
   */
  @PatchMapping("/attachmentimports/{id}")
  public XfR patchUpdate(@RequestBody AttachmentImport attachmentImport,@PathVariable Long id) {
      AttachmentImport upattachmentImport = attachmentImportServiceImpl.getById(id);
      if(upattachmentImport != null){
        upattachmentImport = ObjectCopyUtils.copyProperties(attachmentImport,upattachmentImport,true);
      }
      return XfR.ok(attachmentImportServiceImpl.updateById(upattachmentImport));
  }

  /**
   * 通过id删除附件查询导入模板
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/attachmentimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(attachmentImportServiceImpl.removeById(id));
  }

  @PostMapping("/attachmentimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "attachment_import");
     params.put("request", condition);

     return XfR.ok(attachmentImportServiceImpl.querys(params));
  }

}
