package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Image;
import com.xforceplus.ultraman.app.elephantarchives.service.IImageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 影像前端控制器
 *
 * @author ultraman
 * @date 2021-10-16
 */
@RestController
public class ImageController {

  @Autowired
  private IImageService imageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param image 影像
   * @return
   */
  @GetMapping("/images" )
  public XfR getImages(XfPage page, Image image) {
    return XfR.ok(imageServiceImpl.page(page, Wrappers.query(image)));
  }

  /**
   * 通过id查询影像
   * @param  id
   * @return XfR
   */
  @GetMapping("/images/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(imageServiceImpl.getById(id));
  }

  /**
   * 新增影像
   * @param image 影像
   * @return XfR
   */
  @PostMapping("/images")
  public XfR save(@RequestBody Image image) {
     return XfR.ok(imageServiceImpl.save(image));
  }

  /**
   * 修改-传入修改后的全部数据影像
   * @param image 影像
   * @return XfR
   */
  @PutMapping("/images/{id}")
  public XfR putUpdate(@RequestBody Image image,@PathVariable Long id) {
      image.setId(id);
      return XfR.ok(imageServiceImpl.updateById(image));
  }

  /**
   * 修改-传入修改的数据影像
   * @param image 影像
   * @return XfR
   */
  @PatchMapping("/images/{id}")
  public XfR patchUpdate(@RequestBody Image image,@PathVariable Long id) {
      Image upimage = imageServiceImpl.getById(id);
      if(upimage != null){
        upimage = ObjectCopyUtils.copyProperties(image,upimage,true);
      }
      return XfR.ok(imageServiceImpl.updateById(upimage));
  }

  /**
   * 通过id删除影像
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/images/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(imageServiceImpl.removeById(id));
  }

  @PostMapping("/images/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "image");
     params.put("request", condition);

     return XfR.ok(imageServiceImpl.querys(params));
  }

}
