package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketMachine;
import com.xforceplus.ultraman.app.elephantarchives.service.ITicketMachineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 通用机打前端控制器
 *
 * @author ultraman
 * @date 2021-10-16
 */
@RestController
public class TicketMachineController {

  @Autowired
  private ITicketMachineService ticketMachineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketMachine 通用机打
   * @return
   */
  @GetMapping("/ticketmachines" )
  public XfR getTicketMachines(XfPage page, TicketMachine ticketMachine) {
    return XfR.ok(ticketMachineServiceImpl.page(page, Wrappers.query(ticketMachine)));
  }

  /**
   * 通过id查询通用机打
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketmachines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketMachineServiceImpl.getById(id));
  }

  /**
   * 新增通用机打
   * @param ticketMachine 通用机打
   * @return XfR
   */
  @PostMapping("/ticketmachines")
  public XfR save(@RequestBody TicketMachine ticketMachine) {
     return XfR.ok(ticketMachineServiceImpl.save(ticketMachine));
  }

  /**
   * 修改-传入修改后的全部数据通用机打
   * @param ticketMachine 通用机打
   * @return XfR
   */
  @PutMapping("/ticketmachines/{id}")
  public XfR putUpdate(@RequestBody TicketMachine ticketMachine,@PathVariable Long id) {
      ticketMachine.setId(id);
      return XfR.ok(ticketMachineServiceImpl.updateById(ticketMachine));
  }

  /**
   * 修改-传入修改的数据通用机打
   * @param ticketMachine 通用机打
   * @return XfR
   */
  @PatchMapping("/ticketmachines/{id}")
  public XfR patchUpdate(@RequestBody TicketMachine ticketMachine,@PathVariable Long id) {
      TicketMachine upticketMachine = ticketMachineServiceImpl.getById(id);
      if(upticketMachine != null){
        upticketMachine = ObjectCopyUtils.copyProperties(ticketMachine,upticketMachine,true);
      }
      return XfR.ok(ticketMachineServiceImpl.updateById(upticketMachine));
  }

  /**
   * 通过id删除通用机打
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketmachines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketMachineServiceImpl.removeById(id));
  }

  @PostMapping("/ticketmachines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_machine");
     params.put("request", condition);

     return XfR.ok(ticketMachineServiceImpl.querys(params));
  }

}
