package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TransferFlow;
import com.xforceplus.ultraman.app.elephantarchives.service.ITransferFlowService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 转移流程表前端控制器
 *
 * @author ultraman
 * @date 2021-10-16
 */
@RestController
public class TransferFlowController {

  @Autowired
  private ITransferFlowService transferFlowServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param transferFlow 转移流程表
   * @return
   */
  @GetMapping("/transferflows" )
  public XfR getTransferFlows(XfPage page, TransferFlow transferFlow) {
    return XfR.ok(transferFlowServiceImpl.page(page, Wrappers.query(transferFlow)));
  }

  /**
   * 通过id查询转移流程表
   * @param  id
   * @return XfR
   */
  @GetMapping("/transferflows/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(transferFlowServiceImpl.getById(id));
  }

  /**
   * 新增转移流程表
   * @param transferFlow 转移流程表
   * @return XfR
   */
  @PostMapping("/transferflows")
  public XfR save(@RequestBody TransferFlow transferFlow) {
     return XfR.ok(transferFlowServiceImpl.save(transferFlow));
  }

  /**
   * 修改-传入修改后的全部数据转移流程表
   * @param transferFlow 转移流程表
   * @return XfR
   */
  @PutMapping("/transferflows/{id}")
  public XfR putUpdate(@RequestBody TransferFlow transferFlow,@PathVariable Long id) {
      transferFlow.setId(id);
      return XfR.ok(transferFlowServiceImpl.updateById(transferFlow));
  }

  /**
   * 修改-传入修改的数据转移流程表
   * @param transferFlow 转移流程表
   * @return XfR
   */
  @PatchMapping("/transferflows/{id}")
  public XfR patchUpdate(@RequestBody TransferFlow transferFlow,@PathVariable Long id) {
      TransferFlow uptransferFlow = transferFlowServiceImpl.getById(id);
      if(uptransferFlow != null){
        uptransferFlow = ObjectCopyUtils.copyProperties(transferFlow,uptransferFlow,true);
      }
      return XfR.ok(transferFlowServiceImpl.updateById(uptransferFlow));
  }

  /**
   * 通过id删除转移流程表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/transferflows/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(transferFlowServiceImpl.removeById(id));
  }

  @PostMapping("/transferflows/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "transfer_flow");
     params.put("request", condition);

     return XfR.ok(transferFlowServiceImpl.querys(params));
  }

}
