package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Detection;
import com.xforceplus.ultraman.app.elephantarchives.service.IDetectionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 四性检测前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class DetectionController {

  @Autowired
  private IDetectionService detectionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param detection 四性检测
   * @return
   */
  @GetMapping("/detections" )
  public XfR getDetections(XfPage page, Detection detection) {
    return XfR.ok(detectionServiceImpl.page(page, Wrappers.query(detection)));
  }

  /**
   * 通过id查询四性检测
   * @param  id
   * @return XfR
   */
  @GetMapping("/detections/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(detectionServiceImpl.getById(id));
  }

  /**
   * 新增四性检测
   * @param detection 四性检测
   * @return XfR
   */
  @PostMapping("/detections")
  public XfR save(@RequestBody Detection detection) {
     return XfR.ok(detectionServiceImpl.save(detection));
  }

  /**
   * 修改-传入修改后的全部数据四性检测
   * @param detection 四性检测
   * @return XfR
   */
  @PutMapping("/detections/{id}")
  public XfR putUpdate(@RequestBody Detection detection,@PathVariable Long id) {
      detection.setId(id);
      return XfR.ok(detectionServiceImpl.updateById(detection));
  }

  /**
   * 修改-传入修改的数据四性检测
   * @param detection 四性检测
   * @return XfR
   */
  @PatchMapping("/detections/{id}")
  public XfR patchUpdate(@RequestBody Detection detection,@PathVariable Long id) {
      Detection updetection = detectionServiceImpl.getById(id);
      if(updetection != null){
        updetection = ObjectCopyUtils.copyProperties(detection,updetection,true);
      }
      return XfR.ok(detectionServiceImpl.updateById(updetection));
  }

  /**
   * 通过id删除四性检测
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/detections/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(detectionServiceImpl.removeById(id));
  }

  @PostMapping("/detections/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "detection");
     params.put("request", condition);

     return XfR.ok(detectionServiceImpl.querys(params));
  }

}
