package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.InventoryResult;
import com.xforceplus.ultraman.app.elephantarchives.service.IInventoryResultService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 盘点结果表前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class InventoryResultController {

  @Autowired
  private IInventoryResultService inventoryResultServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inventoryResult 盘点结果表
   * @return
   */
  @GetMapping("/inventoryresults" )
  public XfR getInventoryResults(XfPage page, InventoryResult inventoryResult) {
    return XfR.ok(inventoryResultServiceImpl.page(page, Wrappers.query(inventoryResult)));
  }

  /**
   * 通过id查询盘点结果表
   * @param  id
   * @return XfR
   */
  @GetMapping("/inventoryresults/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inventoryResultServiceImpl.getById(id));
  }

  /**
   * 新增盘点结果表
   * @param inventoryResult 盘点结果表
   * @return XfR
   */
  @PostMapping("/inventoryresults")
  public XfR save(@RequestBody InventoryResult inventoryResult) {
     return XfR.ok(inventoryResultServiceImpl.save(inventoryResult));
  }

  /**
   * 修改-传入修改后的全部数据盘点结果表
   * @param inventoryResult 盘点结果表
   * @return XfR
   */
  @PutMapping("/inventoryresults/{id}")
  public XfR putUpdate(@RequestBody InventoryResult inventoryResult,@PathVariable Long id) {
      inventoryResult.setId(id);
      return XfR.ok(inventoryResultServiceImpl.updateById(inventoryResult));
  }

  /**
   * 修改-传入修改的数据盘点结果表
   * @param inventoryResult 盘点结果表
   * @return XfR
   */
  @PatchMapping("/inventoryresults/{id}")
  public XfR patchUpdate(@RequestBody InventoryResult inventoryResult,@PathVariable Long id) {
      InventoryResult upinventoryResult = inventoryResultServiceImpl.getById(id);
      if(upinventoryResult != null){
        upinventoryResult = ObjectCopyUtils.copyProperties(inventoryResult,upinventoryResult,true);
      }
      return XfR.ok(inventoryResultServiceImpl.updateById(upinventoryResult));
  }

  /**
   * 通过id删除盘点结果表
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inventoryresults/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inventoryResultServiceImpl.removeById(id));
  }

  @PostMapping("/inventoryresults/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inventory_result");
     params.put("request", condition);

     return XfR.ok(inventoryResultServiceImpl.querys(params));
  }

}
