package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketInvoiceImport;
import com.xforceplus.ultraman.app.elephantarchives.service.ITicketInvoiceImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 发票导入查询模板前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class TicketInvoiceImportController {

  @Autowired
  private ITicketInvoiceImportService ticketInvoiceImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketInvoiceImport 发票导入查询模板
   * @return
   */
  @GetMapping("/ticketinvoiceimports" )
  public XfR getTicketInvoiceImports(XfPage page, TicketInvoiceImport ticketInvoiceImport) {
    return XfR.ok(ticketInvoiceImportServiceImpl.page(page, Wrappers.query(ticketInvoiceImport)));
  }

  /**
   * 通过id查询发票导入查询模板
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketinvoiceimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceImportServiceImpl.getById(id));
  }

  /**
   * 新增发票导入查询模板
   * @param ticketInvoiceImport 发票导入查询模板
   * @return XfR
   */
  @PostMapping("/ticketinvoiceimports")
  public XfR save(@RequestBody TicketInvoiceImport ticketInvoiceImport) {
     return XfR.ok(ticketInvoiceImportServiceImpl.save(ticketInvoiceImport));
  }

  /**
   * 修改-传入修改后的全部数据发票导入查询模板
   * @param ticketInvoiceImport 发票导入查询模板
   * @return XfR
   */
  @PutMapping("/ticketinvoiceimports/{id}")
  public XfR putUpdate(@RequestBody TicketInvoiceImport ticketInvoiceImport,@PathVariable Long id) {
      ticketInvoiceImport.setId(id);
      return XfR.ok(ticketInvoiceImportServiceImpl.updateById(ticketInvoiceImport));
  }

  /**
   * 修改-传入修改的数据发票导入查询模板
   * @param ticketInvoiceImport 发票导入查询模板
   * @return XfR
   */
  @PatchMapping("/ticketinvoiceimports/{id}")
  public XfR patchUpdate(@RequestBody TicketInvoiceImport ticketInvoiceImport,@PathVariable Long id) {
      TicketInvoiceImport upticketInvoiceImport = ticketInvoiceImportServiceImpl.getById(id);
      if(upticketInvoiceImport != null){
        upticketInvoiceImport = ObjectCopyUtils.copyProperties(ticketInvoiceImport,upticketInvoiceImport,true);
      }
      return XfR.ok(ticketInvoiceImportServiceImpl.updateById(upticketInvoiceImport));
  }

  /**
   * 通过id删除发票导入查询模板
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketinvoiceimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketInvoiceImportServiceImpl.removeById(id));
  }

  @PostMapping("/ticketinvoiceimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_invoice_import");
     params.put("request", condition);

     return XfR.ok(ticketInvoiceImportServiceImpl.querys(params));
  }

}
