package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.TicketPlaneDetail;
import com.xforceplus.ultraman.app.elephantarchives.service.ITicketPlaneDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 飞机票明细信息前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class TicketPlaneDetailController {

  @Autowired
  private ITicketPlaneDetailService ticketPlaneDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketPlaneDetail 飞机票明细信息
   * @return
   */
  @GetMapping("/ticketplanedetails" )
  public XfR getTicketPlaneDetails(XfPage page, TicketPlaneDetail ticketPlaneDetail) {
    return XfR.ok(ticketPlaneDetailServiceImpl.page(page, Wrappers.query(ticketPlaneDetail)));
  }

  /**
   * 通过id查询飞机票明细信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketplanedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketPlaneDetailServiceImpl.getById(id));
  }

  /**
   * 新增飞机票明细信息
   * @param ticketPlaneDetail 飞机票明细信息
   * @return XfR
   */
  @PostMapping("/ticketplanedetails")
  public XfR save(@RequestBody TicketPlaneDetail ticketPlaneDetail) {
     return XfR.ok(ticketPlaneDetailServiceImpl.save(ticketPlaneDetail));
  }

  /**
   * 修改-传入修改后的全部数据飞机票明细信息
   * @param ticketPlaneDetail 飞机票明细信息
   * @return XfR
   */
  @PutMapping("/ticketplanedetails/{id}")
  public XfR putUpdate(@RequestBody TicketPlaneDetail ticketPlaneDetail,@PathVariable Long id) {
      ticketPlaneDetail.setId(id);
      return XfR.ok(ticketPlaneDetailServiceImpl.updateById(ticketPlaneDetail));
  }

  /**
   * 修改-传入修改的数据飞机票明细信息
   * @param ticketPlaneDetail 飞机票明细信息
   * @return XfR
   */
  @PatchMapping("/ticketplanedetails/{id}")
  public XfR patchUpdate(@RequestBody TicketPlaneDetail ticketPlaneDetail,@PathVariable Long id) {
      TicketPlaneDetail upticketPlaneDetail = ticketPlaneDetailServiceImpl.getById(id);
      if(upticketPlaneDetail != null){
        upticketPlaneDetail = ObjectCopyUtils.copyProperties(ticketPlaneDetail,upticketPlaneDetail,true);
      }
      return XfR.ok(ticketPlaneDetailServiceImpl.updateById(upticketPlaneDetail));
  }

  /**
   * 通过id删除飞机票明细信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketplanedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketPlaneDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketplanedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_plane_detail");
     params.put("request", condition);

     return XfR.ok(ticketPlaneDetailServiceImpl.querys(params));
  }

}
