package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeImport;
import com.xforceplus.ultraman.app.elephantarchives.service.IVolumeImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 待分册导入查询模板前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class VolumeImportController {

  @Autowired
  private IVolumeImportService volumeImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volumeImport 待分册导入查询模板
   * @return
   */
  @GetMapping("/volumeimports" )
  public XfR getVolumeImports(XfPage page, VolumeImport volumeImport) {
    return XfR.ok(volumeImportServiceImpl.page(page, Wrappers.query(volumeImport)));
  }

  /**
   * 通过id查询待分册导入查询模板
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumeimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumeImportServiceImpl.getById(id));
  }

  /**
   * 新增待分册导入查询模板
   * @param volumeImport 待分册导入查询模板
   * @return XfR
   */
  @PostMapping("/volumeimports")
  public XfR save(@RequestBody VolumeImport volumeImport) {
     return XfR.ok(volumeImportServiceImpl.save(volumeImport));
  }

  /**
   * 修改-传入修改后的全部数据待分册导入查询模板
   * @param volumeImport 待分册导入查询模板
   * @return XfR
   */
  @PutMapping("/volumeimports/{id}")
  public XfR putUpdate(@RequestBody VolumeImport volumeImport,@PathVariable Long id) {
      volumeImport.setId(id);
      return XfR.ok(volumeImportServiceImpl.updateById(volumeImport));
  }

  /**
   * 修改-传入修改的数据待分册导入查询模板
   * @param volumeImport 待分册导入查询模板
   * @return XfR
   */
  @PatchMapping("/volumeimports/{id}")
  public XfR patchUpdate(@RequestBody VolumeImport volumeImport,@PathVariable Long id) {
      VolumeImport upvolumeImport = volumeImportServiceImpl.getById(id);
      if(upvolumeImport != null){
        upvolumeImport = ObjectCopyUtils.copyProperties(volumeImport,upvolumeImport,true);
      }
      return XfR.ok(volumeImportServiceImpl.updateById(upvolumeImport));
  }

  /**
   * 通过id删除待分册导入查询模板
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumeimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumeImportServiceImpl.removeById(id));
  }

  @PostMapping("/volumeimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume_import");
     params.put("request", condition);

     return XfR.ok(volumeImportServiceImpl.querys(params));
  }

}
