package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumePartitionRecord;
import com.xforceplus.ultraman.app.elephantarchives.service.IVolumePartitionRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 拆册记录前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class VolumePartitionRecordController {

  @Autowired
  private IVolumePartitionRecordService volumePartitionRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volumePartitionRecord 拆册记录
   * @return
   */
  @GetMapping("/volumepartitionrecords" )
  public XfR getVolumePartitionRecords(XfPage page, VolumePartitionRecord volumePartitionRecord) {
    return XfR.ok(volumePartitionRecordServiceImpl.page(page, Wrappers.query(volumePartitionRecord)));
  }

  /**
   * 通过id查询拆册记录
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumepartitionrecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumePartitionRecordServiceImpl.getById(id));
  }

  /**
   * 新增拆册记录
   * @param volumePartitionRecord 拆册记录
   * @return XfR
   */
  @PostMapping("/volumepartitionrecords")
  public XfR save(@RequestBody VolumePartitionRecord volumePartitionRecord) {
     return XfR.ok(volumePartitionRecordServiceImpl.save(volumePartitionRecord));
  }

  /**
   * 修改-传入修改后的全部数据拆册记录
   * @param volumePartitionRecord 拆册记录
   * @return XfR
   */
  @PutMapping("/volumepartitionrecords/{id}")
  public XfR putUpdate(@RequestBody VolumePartitionRecord volumePartitionRecord,@PathVariable Long id) {
      volumePartitionRecord.setId(id);
      return XfR.ok(volumePartitionRecordServiceImpl.updateById(volumePartitionRecord));
  }

  /**
   * 修改-传入修改的数据拆册记录
   * @param volumePartitionRecord 拆册记录
   * @return XfR
   */
  @PatchMapping("/volumepartitionrecords/{id}")
  public XfR patchUpdate(@RequestBody VolumePartitionRecord volumePartitionRecord,@PathVariable Long id) {
      VolumePartitionRecord upvolumePartitionRecord = volumePartitionRecordServiceImpl.getById(id);
      if(upvolumePartitionRecord != null){
        upvolumePartitionRecord = ObjectCopyUtils.copyProperties(volumePartitionRecord,upvolumePartitionRecord,true);
      }
      return XfR.ok(volumePartitionRecordServiceImpl.updateById(upvolumePartitionRecord));
  }

  /**
   * 通过id删除拆册记录
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumepartitionrecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumePartitionRecordServiceImpl.removeById(id));
  }

  @PostMapping("/volumepartitionrecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume_partition_record");
     params.put("request", condition);

     return XfR.ok(volumePartitionRecordServiceImpl.querys(params));
  }

}
