package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ArchiveSearch;
import com.xforceplus.ultraman.app.elephantarchives.service.IArchiveSearchService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 档案查询专用对象前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class ArchiveSearchController {

  @Autowired
  private IArchiveSearchService archiveSearchServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param archiveSearch 档案查询专用对象
   * @return
   */
  @GetMapping("/archivesearchs" )
  public XfR getArchiveSearchs(XfPage page, ArchiveSearch archiveSearch) {
    return XfR.ok(archiveSearchServiceImpl.page(page, Wrappers.query(archiveSearch)));
  }

  /**
   * 通过id查询档案查询专用对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/archivesearchs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(archiveSearchServiceImpl.getById(id));
  }

  /**
   * 新增档案查询专用对象
   * @param archiveSearch 档案查询专用对象
   * @return XfR
   */
  @PostMapping("/archivesearchs")
  public XfR save(@RequestBody ArchiveSearch archiveSearch) {
     return XfR.ok(archiveSearchServiceImpl.save(archiveSearch));
  }

  /**
   * 修改-传入修改后的全部数据档案查询专用对象
   * @param archiveSearch 档案查询专用对象
   * @return XfR
   */
  @PutMapping("/archivesearchs/{id}")
  public XfR putUpdate(@RequestBody ArchiveSearch archiveSearch,@PathVariable Long id) {
      archiveSearch.setId(id);
      return XfR.ok(archiveSearchServiceImpl.updateById(archiveSearch));
  }

  /**
   * 修改-传入修改的数据档案查询专用对象
   * @param archiveSearch 档案查询专用对象
   * @return XfR
   */
  @PatchMapping("/archivesearchs/{id}")
  public XfR patchUpdate(@RequestBody ArchiveSearch archiveSearch,@PathVariable Long id) {
      ArchiveSearch uparchiveSearch = archiveSearchServiceImpl.getById(id);
      if(uparchiveSearch != null){
        uparchiveSearch = ObjectCopyUtils.copyProperties(archiveSearch,uparchiveSearch,true);
      }
      return XfR.ok(archiveSearchServiceImpl.updateById(uparchiveSearch));
  }

  /**
   * 通过id删除档案查询专用对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/archivesearchs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(archiveSearchServiceImpl.removeById(id));
  }

  @PostMapping("/archivesearchs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "archive_search");
     params.put("request", condition);

     return XfR.ok(archiveSearchServiceImpl.querys(params));
  }

}
