package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.BaseVoucher;
import com.xforceplus.ultraman.app.elephantarchives.service.IBaseVoucherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 基础凭证前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class BaseVoucherController {

  @Autowired
  private IBaseVoucherService baseVoucherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseVoucher 基础凭证
   * @return
   */
  @GetMapping("/basevouchers" )
  public XfR getBaseVouchers(XfPage page, BaseVoucher baseVoucher) {
    return XfR.ok(baseVoucherServiceImpl.page(page, Wrappers.query(baseVoucher)));
  }

  /**
   * 通过id查询基础凭证
   * @param  id
   * @return XfR
   */
  @GetMapping("/basevouchers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseVoucherServiceImpl.getById(id));
  }

  /**
   * 新增基础凭证
   * @param baseVoucher 基础凭证
   * @return XfR
   */
  @PostMapping("/basevouchers")
  public XfR save(@RequestBody BaseVoucher baseVoucher) {
     return XfR.ok(baseVoucherServiceImpl.save(baseVoucher));
  }

  /**
   * 修改-传入修改后的全部数据基础凭证
   * @param baseVoucher 基础凭证
   * @return XfR
   */
  @PutMapping("/basevouchers/{id}")
  public XfR putUpdate(@RequestBody BaseVoucher baseVoucher,@PathVariable Long id) {
      baseVoucher.setId(id);
      return XfR.ok(baseVoucherServiceImpl.updateById(baseVoucher));
  }

  /**
   * 修改-传入修改的数据基础凭证
   * @param baseVoucher 基础凭证
   * @return XfR
   */
  @PatchMapping("/basevouchers/{id}")
  public XfR patchUpdate(@RequestBody BaseVoucher baseVoucher,@PathVariable Long id) {
      BaseVoucher upbaseVoucher = baseVoucherServiceImpl.getById(id);
      if(upbaseVoucher != null){
        upbaseVoucher = ObjectCopyUtils.copyProperties(baseVoucher,upbaseVoucher,true);
      }
      return XfR.ok(baseVoucherServiceImpl.updateById(upbaseVoucher));
  }

  /**
   * 通过id删除基础凭证
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basevouchers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseVoucherServiceImpl.removeById(id));
  }

  @PostMapping("/basevouchers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_voucher");
     params.put("request", condition);

     return XfR.ok(baseVoucherServiceImpl.querys(params));
  }

}
