package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.ConfigArchivesType;
import com.xforceplus.ultraman.app.elephantarchives.service.IConfigArchivesTypeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 类型配置前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class ConfigArchivesTypeController {

  @Autowired
  private IConfigArchivesTypeService configArchivesTypeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configArchivesType 类型配置
   * @return
   */
  @GetMapping("/configarchivestypes" )
  public XfR getConfigArchivesTypes(XfPage page, ConfigArchivesType configArchivesType) {
    return XfR.ok(configArchivesTypeServiceImpl.page(page, Wrappers.query(configArchivesType)));
  }

  /**
   * 通过id查询类型配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/configarchivestypes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configArchivesTypeServiceImpl.getById(id));
  }

  /**
   * 新增类型配置
   * @param configArchivesType 类型配置
   * @return XfR
   */
  @PostMapping("/configarchivestypes")
  public XfR save(@RequestBody ConfigArchivesType configArchivesType) {
     return XfR.ok(configArchivesTypeServiceImpl.save(configArchivesType));
  }

  /**
   * 修改-传入修改后的全部数据类型配置
   * @param configArchivesType 类型配置
   * @return XfR
   */
  @PutMapping("/configarchivestypes/{id}")
  public XfR putUpdate(@RequestBody ConfigArchivesType configArchivesType,@PathVariable Long id) {
      configArchivesType.setId(id);
      return XfR.ok(configArchivesTypeServiceImpl.updateById(configArchivesType));
  }

  /**
   * 修改-传入修改的数据类型配置
   * @param configArchivesType 类型配置
   * @return XfR
   */
  @PatchMapping("/configarchivestypes/{id}")
  public XfR patchUpdate(@RequestBody ConfigArchivesType configArchivesType,@PathVariable Long id) {
      ConfigArchivesType upconfigArchivesType = configArchivesTypeServiceImpl.getById(id);
      if(upconfigArchivesType != null){
        upconfigArchivesType = ObjectCopyUtils.copyProperties(configArchivesType,upconfigArchivesType,true);
      }
      return XfR.ok(configArchivesTypeServiceImpl.updateById(upconfigArchivesType));
  }

  /**
   * 通过id删除类型配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configarchivestypes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configArchivesTypeServiceImpl.removeById(id));
  }

  @PostMapping("/configarchivestypes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_archives_type");
     params.put("request", condition);

     return XfR.ok(configArchivesTypeServiceImpl.querys(params));
  }

}
