package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.GeneralAttribute;
import com.xforceplus.ultraman.app.elephantarchives.service.IGeneralAttributeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 通用属性前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class GeneralAttributeController {

  @Autowired
  private IGeneralAttributeService generalAttributeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param generalAttribute 通用属性
   * @return
   */
  @GetMapping("/generalattributes" )
  public XfR getGeneralAttributes(XfPage page, GeneralAttribute generalAttribute) {
    return XfR.ok(generalAttributeServiceImpl.page(page, Wrappers.query(generalAttribute)));
  }

  /**
   * 通过id查询通用属性
   * @param  id
   * @return XfR
   */
  @GetMapping("/generalattributes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(generalAttributeServiceImpl.getById(id));
  }

  /**
   * 新增通用属性
   * @param generalAttribute 通用属性
   * @return XfR
   */
  @PostMapping("/generalattributes")
  public XfR save(@RequestBody GeneralAttribute generalAttribute) {
     return XfR.ok(generalAttributeServiceImpl.save(generalAttribute));
  }

  /**
   * 修改-传入修改后的全部数据通用属性
   * @param generalAttribute 通用属性
   * @return XfR
   */
  @PutMapping("/generalattributes/{id}")
  public XfR putUpdate(@RequestBody GeneralAttribute generalAttribute,@PathVariable Long id) {
      generalAttribute.setId(id);
      return XfR.ok(generalAttributeServiceImpl.updateById(generalAttribute));
  }

  /**
   * 修改-传入修改的数据通用属性
   * @param generalAttribute 通用属性
   * @return XfR
   */
  @PatchMapping("/generalattributes/{id}")
  public XfR patchUpdate(@RequestBody GeneralAttribute generalAttribute,@PathVariable Long id) {
      GeneralAttribute upgeneralAttribute = generalAttributeServiceImpl.getById(id);
      if(upgeneralAttribute != null){
        upgeneralAttribute = ObjectCopyUtils.copyProperties(generalAttribute,upgeneralAttribute,true);
      }
      return XfR.ok(generalAttributeServiceImpl.updateById(upgeneralAttribute));
  }

  /**
   * 通过id删除通用属性
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/generalattributes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(generalAttributeServiceImpl.removeById(id));
  }

  @PostMapping("/generalattributes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "general_attribute");
     params.put("request", condition);

     return XfR.ok(generalAttributeServiceImpl.querys(params));
  }

}
