package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.OriginalBill;
import com.xforceplus.ultraman.app.elephantarchives.service.IOriginalBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 原始单据前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class OriginalBillController {

  @Autowired
  private IOriginalBillService originalBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param originalBill 原始单据
   * @return
   */
  @GetMapping("/originalbills" )
  public XfR getOriginalBills(XfPage page, OriginalBill originalBill) {
    return XfR.ok(originalBillServiceImpl.page(page, Wrappers.query(originalBill)));
  }

  /**
   * 通过id查询原始单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/originalbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(originalBillServiceImpl.getById(id));
  }

  /**
   * 新增原始单据
   * @param originalBill 原始单据
   * @return XfR
   */
  @PostMapping("/originalbills")
  public XfR save(@RequestBody OriginalBill originalBill) {
     return XfR.ok(originalBillServiceImpl.save(originalBill));
  }

  /**
   * 修改-传入修改后的全部数据原始单据
   * @param originalBill 原始单据
   * @return XfR
   */
  @PutMapping("/originalbills/{id}")
  public XfR putUpdate(@RequestBody OriginalBill originalBill,@PathVariable Long id) {
      originalBill.setId(id);
      return XfR.ok(originalBillServiceImpl.updateById(originalBill));
  }

  /**
   * 修改-传入修改的数据原始单据
   * @param originalBill 原始单据
   * @return XfR
   */
  @PatchMapping("/originalbills/{id}")
  public XfR patchUpdate(@RequestBody OriginalBill originalBill,@PathVariable Long id) {
      OriginalBill uporiginalBill = originalBillServiceImpl.getById(id);
      if(uporiginalBill != null){
        uporiginalBill = ObjectCopyUtils.copyProperties(originalBill,uporiginalBill,true);
      }
      return XfR.ok(originalBillServiceImpl.updateById(uporiginalBill));
  }

  /**
   * 通过id删除原始单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/originalbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(originalBillServiceImpl.removeById(id));
  }

  @PostMapping("/originalbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "original_bill");
     params.put("request", condition);

     return XfR.ok(originalBillServiceImpl.querys(params));
  }

}
