package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.VolumeAppraisalApply;
import com.xforceplus.ultraman.app.elephantarchives.service.IVolumeAppraisalApplyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 档案鉴定申请单前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class VolumeAppraisalApplyController {

  @Autowired
  private IVolumeAppraisalApplyService volumeAppraisalApplyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return
   */
  @GetMapping("/volumeappraisalapplys" )
  public XfR getVolumeAppraisalApplys(XfPage page, VolumeAppraisalApply volumeAppraisalApply) {
    return XfR.ok(volumeAppraisalApplyServiceImpl.page(page, Wrappers.query(volumeAppraisalApply)));
  }

  /**
   * 通过id查询档案鉴定申请单
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumeappraisalapplys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumeAppraisalApplyServiceImpl.getById(id));
  }

  /**
   * 新增档案鉴定申请单
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return XfR
   */
  @PostMapping("/volumeappraisalapplys")
  public XfR save(@RequestBody VolumeAppraisalApply volumeAppraisalApply) {
     return XfR.ok(volumeAppraisalApplyServiceImpl.save(volumeAppraisalApply));
  }

  /**
   * 修改-传入修改后的全部数据档案鉴定申请单
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return XfR
   */
  @PutMapping("/volumeappraisalapplys/{id}")
  public XfR putUpdate(@RequestBody VolumeAppraisalApply volumeAppraisalApply,@PathVariable Long id) {
      volumeAppraisalApply.setId(id);
      return XfR.ok(volumeAppraisalApplyServiceImpl.updateById(volumeAppraisalApply));
  }

  /**
   * 修改-传入修改的数据档案鉴定申请单
   * @param volumeAppraisalApply 档案鉴定申请单
   * @return XfR
   */
  @PatchMapping("/volumeappraisalapplys/{id}")
  public XfR patchUpdate(@RequestBody VolumeAppraisalApply volumeAppraisalApply,@PathVariable Long id) {
      VolumeAppraisalApply upvolumeAppraisalApply = volumeAppraisalApplyServiceImpl.getById(id);
      if(upvolumeAppraisalApply != null){
        upvolumeAppraisalApply = ObjectCopyUtils.copyProperties(volumeAppraisalApply,upvolumeAppraisalApply,true);
      }
      return XfR.ok(volumeAppraisalApplyServiceImpl.updateById(upvolumeAppraisalApply));
  }

  /**
   * 通过id删除档案鉴定申请单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumeappraisalapplys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumeAppraisalApplyServiceImpl.removeById(id));
  }

  @PostMapping("/volumeappraisalapplys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume_appraisal_apply");
     params.put("request", condition);

     return XfR.ok(volumeAppraisalApplyServiceImpl.querys(params));
  }

}
