package com.xforceplus.ultraman.app.elephantarchives.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.elephantarchives.entity.Volume;
import com.xforceplus.ultraman.app.elephantarchives.service.IVolumeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 分册实体前端控制器
 *
 * @author ultraman
 * @date 2022-03-15
 */
@RestController
public class VolumeController {

  @Autowired
  private IVolumeService volumeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param volume 分册实体
   * @return
   */
  @GetMapping("/volumes" )
  public XfR getVolumes(XfPage page, Volume volume) {
    return XfR.ok(volumeServiceImpl.page(page, Wrappers.query(volume)));
  }

  /**
   * 通过id查询分册实体
   * @param  id
   * @return XfR
   */
  @GetMapping("/volumes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(volumeServiceImpl.getById(id));
  }

  /**
   * 新增分册实体
   * @param volume 分册实体
   * @return XfR
   */
  @PostMapping("/volumes")
  public XfR save(@RequestBody Volume volume) {
     return XfR.ok(volumeServiceImpl.save(volume));
  }

  /**
   * 修改-传入修改后的全部数据分册实体
   * @param volume 分册实体
   * @return XfR
   */
  @PutMapping("/volumes/{id}")
  public XfR putUpdate(@RequestBody Volume volume,@PathVariable Long id) {
      volume.setId(id);
      return XfR.ok(volumeServiceImpl.updateById(volume));
  }

  /**
   * 修改-传入修改的数据分册实体
   * @param volume 分册实体
   * @return XfR
   */
  @PatchMapping("/volumes/{id}")
  public XfR patchUpdate(@RequestBody Volume volume,@PathVariable Long id) {
      Volume upvolume = volumeServiceImpl.getById(id);
      if(upvolume != null){
        upvolume = ObjectCopyUtils.copyProperties(volume,upvolume,true);
      }
      return XfR.ok(volumeServiceImpl.updateById(upvolume));
  }

  /**
   * 通过id删除分册实体
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/volumes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(volumeServiceImpl.removeById(id));
  }

  @PostMapping("/volumes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "volume");
     params.put("request", condition);

     return XfR.ok(volumeServiceImpl.querys(params));
  }

}
