package com.xforceplus.ultraman.app.financialsettlement.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2021-09-28
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.financialsettlement.entity.UnitPrice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "financial-settlement")
public interface UnitPriceFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/unitPrice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param unitPrice ${table.comment}
   * @return R
   */
  @PostMapping("/unitPrice/add")
  public R save(@RequestBody UnitPrice unitPrice);

  /**
   * 修改${table.comment}
   * @param unitPrice ${table.comment}
   * @return R
   */
  @PostMapping("/unitPrice/update")
  public R updateById(@RequestBody UnitPrice unitPrice);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/unitPrice/del/{id}" )
  public R removeById(@PathVariable Long id);

}